/**
 * SISTEMX - MÓDULO ADMIN
 * Organizado por Módulos
 */

document.addEventListener('DOMContentLoaded', () => {
    
    // --- 1. ESTADO ---
    let users = JSON.parse(localStorage.getItem('users')) || [];
    let comissoes = JSON.parse(localStorage.getItem('comissoes')) || [];
    let fechamentos = JSON.parse(localStorage.getItem('fechamentos')) || [];

    const logged = localStorage.getItem('loggedUserLogin');
    const currentUser = users.find(u => u.login === logged);

    if (!currentUser || currentUser.role !== 'admin') {
        window.location.href = '../index.html';
        return;
    }
    document.getElementById('logged-user-name').textContent = currentUser.name;

    // --- 2. MÓDULO DE INTERFACE (UI) ---
    const UI = {
        switchPanel: (panelId) => {
            ['panel-home', 'panel-users', 'panel-history', 'panel-backup'].forEach(p => document.getElementById(p).style.display = 'none');
            ['link-home', 'link-users', 'link-history', 'link-backup'].forEach(l => document.getElementById(l).classList.remove('active'));
            document.getElementById(panelId).style.display = 'block';
            document.getElementById('link-' + panelId.split('-')[1]).classList.add('active');

            if (panelId === 'panel-home') UI.renderAdminTable();
            if (panelId === 'panel-users') UI.renderUsers();
            if (panelId === 'panel-history') UI.renderHistoryList();
        },
        renderAdminTable: () => {
            const tbody = document.getElementById('admin-tbody');
            const filterV = document.getElementById('filter-vendedor').value;
            const filterM = document.getElementById('filter-mes').value;
            tbody.innerHTML = '';
            let vol = 0, com = 0;

            comissoes.filter(c => {
                const mV = filterV ? c.vendedor === filterV : true;
                const mM = filterM ? c.mesReferencia === filterM : true;
                return mV && mM && c.status !== 'Fechado';
            }).forEach(c => {
                const idx = comissoes.indexOf(c);
                vol += (c.valorVenda + (c.valorAnterior || 0)); com += c.valorComissao;
                tbody.innerHTML += `
                    <tr>
                        <td><input type="checkbox" class="cb-pago" data-index="${idx}" ${c.status === 'Pago' ? 'disabled' : ''}></td>
                        <td><strong>${c.vendedor}</strong></td>
                        <td>${c.idVenda}</td>
                        <td>${c.mesReferencia}</td>
                        <td>R$ ${c.valorVenda.toFixed(2)}</td>
                        <td>R$ ${c.valorComissao.toFixed(2)}</td>
                        <td><span class="status ${c.status === 'Pago' ? 'pago' : 'nao-pago'}">${c.status}</span></td>
                        <td><button class="acao-button delete-btn" onclick="window.delComm(${idx})"><i class="fa fa-trash"></i></button></td>
                    </tr>`;
            });
            document.getElementById('total-volume-admin').textContent = vol.toLocaleString('pt-BR', {style:'currency', currency:'BRL'});
            document.getElementById('total-comissoes-admin').textContent = com.toLocaleString('pt-BR', {style:'currency', currency:'BRL'});
        },
        renderUsers: () => {
            const pList = document.getElementById('pending-users-list');
            const aTbody = document.getElementById('active-users-tbody');
            const pSection = document.getElementById('pending-users-section');
            pList.innerHTML = ''; aTbody.innerHTML = '';

            users.forEach((u, i) => {
                if (u.role === 'pendente') {
                    const div = document.createElement('div');
                    div.style = "display:flex; justify-content:space-between; background:#fff; padding:15px; margin-bottom:10px; border-radius:8px; border-left:5px solid var(--warning);";
                    div.innerHTML = `
                        <div><strong>${u.name}</strong><br><small>${u.funcao} | ${u.unidade}</small></div>
                        <div><button class="save-work-btn" onclick="window.apprUser(${i})">Aprovar</button>
                        <button class="delete-btn" onclick="window.delUser(${i})">Rejeitar</button></div>`;
                    pList.appendChild(div);
                } else {
                    aTbody.innerHTML += `
                        <tr>
                            <td>${u.name}</td><td>${u.login}</td><td>${u.role.toUpperCase()}</td>
                            <td>
                                <button class="acao-button edit-btn" onclick="window.resetPass(${i})"><i class="fa fa-key"></i></button>
                                <button class="acao-button delete-btn" onclick="window.delUser(${i})" ${u.login === 'Sousajss' ? 'disabled' : ''}><i class="fa fa-trash"></i></button>
                            </td>
                        </tr>`;
                }
            });
            pSection.style.display = pList.children.length ? 'block' : 'none';
        },
        renderHistoryList: () => {
            const list = document.getElementById('history-list-admin');
            list.innerHTML = '';
            fechamentos.sort((a,b) => b.id - a.id).forEach(f => {
                const total = f.itens.reduce((acc, i) => acc + i.valorComissao, 0);
                const div = document.createElement('div');
                div.className = "form-container"; div.style.cursor = "pointer";
                div.innerHTML = `<strong>Lote: ${new Date(f.data).toLocaleDateString()}</strong> | Total Pago: R$ ${total.toFixed(2)}`;
                div.onclick = () => window.viewLote(f.id);
                list.appendChild(div);
            });
        }
    };

    // --- 3. EVENT LISTENERS ---
    
    // Links Sidebar
    document.getElementById('link-home').onclick = () => UI.switchPanel('panel-home');
    document.getElementById('link-users').onclick = () => UI.switchPanel('panel-users');
    document.getElementById('link-history').onclick = () => UI.switchPanel('panel-history');
    document.getElementById('link-backup').onclick = () => UI.switchPanel('panel-backup');

    // Botão Pagar
    document.getElementById('btn-pagar').onclick = () => {
        const checks = document.querySelectorAll('.cb-pago:checked');
        if (!checks.length) return alert('Selecione lançamentos.');
        checks.forEach(cb => comissoes[cb.dataset.index].status = 'Pago');
        localStorage.setItem('comissoes', JSON.stringify(comissoes));
        UI.renderAdminTable();
    };

    // Fechar Mês (Filtro Corrigido)
    document.getElementById('btn-fechar-mes').onclick = () => {
        const fV = document.getElementById('filter-vendedor').value;
        const fM = document.getElementById('filter-mes').value;
        const pagasVisiveis = comissoes.filter(c => {
            const mV = fV ? c.vendedor === fV : true;
            const mM = fM ? c.mesReferencia === fM : true;
            return mV && mM && c.status === 'Pago';
        });

        if (!pagasVisiveis.length) return alert('Não há lançamentos PAGOS visíveis para fechar.');
        if (confirm(`Fechar lote de ${pagasVisiveis.length} itens?`)) {
            fechamentos.push({ id: Date.now(), data: new Date().toISOString(), responsavel: currentUser.name, itens: JSON.parse(JSON.stringify(pagasVisiveis)) });
            pagasVisiveis.forEach(c => c.status = 'Fechado');
            localStorage.setItem('fechamentos', JSON.stringify(fechamentos));
            localStorage.setItem('comissoes', JSON.stringify(comissoes));
            UI.renderAdminTable();
        }
    };

    // Cadastro Manual
    document.getElementById('user-form-manual').onsubmit = (e) => {
        e.preventDefault();
        users.push({
            name: document.getElementById('new-name').value,
            login: document.getElementById('new-login').value,
            pass: document.getElementById('new-pass').value,
            role: document.getElementById('new-role').value
        });
        localStorage.setItem('users', JSON.stringify(users));
        alert('Usuário criado.');
        e.target.reset();
        UI.renderUsers();
    };

    // Logout
    document.getElementById('btn-logout').onclick = () => { localStorage.removeItem('loggedUserLogin'); window.location.href = '../index.html'; };

    // Filtros
    users.filter(u => u.role === 'vendedor').forEach(u => {
        document.getElementById('filter-vendedor').innerHTML += `<option value="${u.name}">${u.name}</option>`;
    });
    document.getElementById('filter-vendedor').onchange = UI.renderAdminTable;
    document.getElementById('filter-mes').onchange = UI.renderAdminTable;

    // Backup
    document.getElementById('btn-download-backup').onclick = () => {
        const blob = new Blob([JSON.stringify({users, comissoes, fechamentos})], {type: 'application/json'});
        const a = document.createElement('a'); a.href = URL.createObjectURL(blob); a.download = "backup.json"; a.click();
    };

    // --- 4. FUNÇÕES GLOBAIS (WINDOW) ---
    window.apprUser = (i) => { users[i].role = 'vendedor'; localStorage.setItem('users', JSON.stringify(users)); UI.renderUsers(); };
    window.delUser = (i) => { if (confirm("Excluir usuário?")) { users.splice(i, 1); localStorage.setItem('users', JSON.stringify(users)); UI.renderUsers(); } };
    window.resetPass = (i) => { const n = prompt("Nova senha:"); if(n){ users[i].pass = n; localStorage.setItem('users', JSON.stringify(users)); alert('Senha alterada.'); } };
    window.delComm = (idx) => { if(confirm("Excluir comissão?")) { comissoes.splice(idx, 1); localStorage.setItem('comissoes', JSON.stringify(comissoes)); UI.renderAdminTable(); } };
    
    window.viewLote = (id) => {
        const lote = fechamentos.find(f => f.id === id);
        const area = document.getElementById('history-details-area');
        const tbody = document.getElementById('details-tbody');
        area.style.display = 'block'; tbody.innerHTML = '';
        lote.itens.forEach(i => {
            tbody.innerHTML += `<tr><td>${i.vendedor}</td><td>${i.idVenda}</td><td>${i.mesReferencia}</td><td>R$ ${i.valorComissao.toFixed(2)}</td></tr>`;
        });
        document.getElementById('btn-export-lote').onclick = () => {
            const ws = XLSX.utils.json_to_sheet(lote.itens);
            const wb = XLSX.utils.book_new(); XLSX.utils.book_append_sheet(wb, ws, "Lote");
            XLSX.writeFile(wb, `Fechamento_${id}.xlsx`);
        };
        document.getElementById('btn-estorno-lote').onclick = () => {
            if (!confirm("Estornar?")) return;
            lote.itens.forEach(iL => {
                const orig = comissoes.find(c => c.dataCriacao === iL.dataCriacao && c.vendedor === iL.vendedor);
                if (orig) orig.status = 'Pago';
            });
            fechamentos = fechamentos.filter(f => f.id !== id);
            localStorage.setItem('fechamentos', JSON.stringify(fechamentos));
            localStorage.setItem('comissoes', JSON.stringify(comissoes));
            area.style.display = 'none'; UI.renderHistoryList();
        };
    };
    window.closeDet = () => document.getElementById('history-details-area').style.display = 'none';

    // Init
    UI.renderAdminTable();
});