<?php
// O header já inicia a sessão e faz a verificação de login
require_once 'admin_header.php';

function gerarNomeUsuario($nomeCompleto) {
    $stopwords = ['de', 'da', 'do', 'das', 'dos', 'e'];
    $nomeLimpo = mb_strtolower(trim($nomeCompleto), 'UTF-8');
    $partesNome = explode(' ', $nomeLimpo);
    $partesSignificativas = array_values(array_diff($partesNome, $stopwords));
    if (empty($partesSignificativas)) {
        return '';
    }
    $ultimoNome = end($partesSignificativas);
    $iniciais = '';
    foreach ($partesSignificativas as $parte) {
        if (!empty($parte)) {
           $iniciais .= mb_substr($parte, 0, 1, 'UTF-8');
        }
    }
    return $ultimoNome . $iniciais;
}

$usuariosFile = __DIR__ . '/../../dados_seguros/usuarios.json';
$usuarios = file_exists($usuariosFile) ? json_decode(file_get_contents($usuariosFile), true) : [];
if ($usuarios === null) {
    $usuarios = [];
}
$mensagem = '';
$erro = '';
$usuario_para_editar = null;

define('JSON_SAFE_OPTIONS', JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_SUBSTITUTE);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // --- LÓGICA DE ADICIONAR USUÁRIO ---
    if (isset($_POST['add_user'])) {
        $nome = preg_replace('/[^a-zA-Z\p{L}\s]/u', '', trim($_POST['nome']));
        $unidade = trim($_POST['unidade']);
        $cpf = preg_replace('/[^0-9]/', '', $_POST['cpf']);
        $aniversario = $_POST['aniversario'];
        $sexo = $_POST['sexo'];
        $cargo = $_POST['cargo']; // Novo campo

        if (!empty($nome) && !empty($unidade) && !empty($cpf)) {
            $cpf_exists = false;
            foreach ($usuarios as $usuario) {
                if ($usuario['cpf'] === $cpf) { $cpf_exists = true; break; }
            }
            if ($cpf_exists) {
                $erro = 'Este CPF já está cadastrado.';
            } else {
                $username = gerarNomeUsuario($nome);
                $senha_hash = password_hash($cpf, PASSWORD_DEFAULT);
                $usuarios[] = ['nome' => $nome, 'unidade' => $unidade, 'cpf' => $cpf, 'usuario' => $username, 'senha_hash' => $senha_hash, 'aniversario' => $aniversario, 'sexo' => $sexo, 'cargo' => $cargo];
                file_put_contents($usuariosFile, json_encode($usuarios, JSON_SAFE_OPTIONS));
                $mensagem = "Usuário adicionado com sucesso! O nome de usuário gerado é: <strong>$username</strong>";
            }
        } else {
            $erro = 'Todos os campos são obrigatórios.';
        }
    }

    // --- LÓGICA DE ATUALIZAR USUÁRIO ---
    if (isset($_POST['update_user'])) {
        $cpf_original = $_POST['cpf_original'];
        $nome = preg_replace('/[^a-zA-Z\p{L}\s]/u', '', trim($_POST['nome']));
        $unidade = trim($_POST['unidade']);
        $aniversario = $_POST['aniversario'];
        $sexo = $_POST['sexo'];
        $cargo = $_POST['cargo']; // Novo campo
        $nova_senha_cpf = preg_replace('/[^0-9]/', '', $_POST['nova_senha_cpf']);

        foreach ($usuarios as $i => $usuario) {
            if ($usuario['cpf'] === $cpf_original) {
                $usuarios[$i]['nome'] = $nome;
                $usuarios[$i]['unidade'] = $unidade;
                $usuarios[$i]['aniversario'] = $aniversario;
                $usuarios[$i]['sexo'] = $sexo;
                $usuarios[$i]['cargo'] = $cargo;
                $usuarios[$i]['usuario'] = gerarNomeUsuario($nome);
                if (!empty($nova_senha_cpf)) {
                    $usuarios[$i]['senha_hash'] = password_hash($nova_senha_cpf, PASSWORD_DEFAULT);
                }
                break;
            }
        }
        file_put_contents($usuariosFile, json_encode($usuarios, JSON_SAFE_OPTIONS));
        $mensagem = 'Usuário atualizado com sucesso!';
    }

    // --- LÓGICA DE REMOVER USUÁRIO ---
    if (isset($_POST['delete_user'])) {
        $cpf_to_delete = $_POST['cpf'];
        $usuarios = array_filter($usuarios, function($user) use ($cpf_to_delete) {
            return $user['cpf'] !== $cpf_to_delete;
        });
        $usuarios = array_values($usuarios);
        file_put_contents($usuariosFile, json_encode($usuarios, JSON_SAFE_OPTIONS));
        $mensagem = 'Usuário removido com sucesso!';
    }
}

// --- LÓGICA PARA PREPARAR A EDIÇÃO ---
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['cpf'])) {
    foreach ($usuarios as $usuario) {
        if ($usuario['cpf'] === $_GET['cpf']) {
            $usuario_para_editar = $usuario;
            break;
        }
    }
}
?>

<header>
    <h1>Gerenciar Usuários da Intranet</h1>
    <a href="logout.php" class="btn-logout">Sair</a>
</header>

<div class="card">
    <?php if ($mensagem): ?><p class="message success"><?= $mensagem ?></p><?php endif; ?>
    <?php if ($erro): ?><p class="message error"><?= htmlspecialchars($erro) ?></p><?php endif; ?>

    <!-- Formulário Dinâmico -->
    <?php if ($usuario_para_editar): ?>
    <!-- MODO DE EDIÇÃO -->
    <form method="post" action="gerenciar_usuarios.php" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #eee;">
        <h2>Editando Usuário: <?= htmlspecialchars($usuario_para_editar['nome']) ?></h2>
        <input type="hidden" name="cpf_original" value="<?= htmlspecialchars($usuario_para_editar['cpf']) ?>">
        <div class="form-group"><label>Nome Completo:</label><input type="text" name="nome" value="<?= htmlspecialchars($usuario_para_editar['nome']) ?>" required></div>
        <div class="form-group"><label>Cargo:</label><select name="cargo" required><option value="Colaborador" <?= ($usuario_para_editar['cargo'] ?? 'Colaborador') === 'Colaborador' ? 'selected' : '' ?>>Colaborador</option><option value="Administrador" <?= ($usuario_para_editar['cargo'] ?? '') === 'Administrador' ? 'selected' : '' ?>>Administrador</option></select></div>
        <div class="form-group"><label>Sexo:</label><select name="sexo" required><option value="Masculino" <?= ($usuario_para_editar['sexo'] ?? '') === 'Masculino' ? 'selected' : '' ?>>Masculino</option><option value="Feminino" <?= ($usuario_para_editar['sexo'] ?? '') === 'Feminino' ? 'selected' : '' ?>>Feminino</option></select></div>
        <div class="form-group"><label>Unidade:</label><input type="text" name="unidade" value="<?= htmlspecialchars($usuario_para_editar['unidade']) ?>" required></div>
        <div class="form-group"><label>Data de Aniversário:</label><input type="date" name="aniversario" value="<?= htmlspecialchars($usuario_para_editar['aniversario'] ?? '') ?>"></div>
        <div class="form-group"><label>CPF (Apenas para consulta):</label><input type="text" value="<?= htmlspecialchars($usuario_para_editar['cpf']) ?>" readonly style="background:#f0f0f0;"></div>
        <div class="form-group"><label>Nova Senha (CPF):</label><input type="text" name="nova_senha_cpf" placeholder="Deixe em branco para não alterar"></div>
        <button type="submit" name="update_user" class="btn-add">Salvar Alterações</button>
        <a href="gerenciar_usuarios.php" class="btn-cancel">Cancelar Edição</a>
    </form>
    <?php else: ?>
    <!-- MODO DE ADIÇÃO -->
    <form method="post" action="gerenciar_usuarios.php" style="margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #eee;">
        <h2>Adicionar Novo Usuário</h2>
        <div class="form-group"><label>Nome Completo:</label><input type="text" name="nome" required></div>
        <div class="form-group"><label>Cargo:</label><select name="cargo" required><option value="Colaborador" selected>Colaborador</option><option value="Administrador">Administrador</option></select></div>
        <div class="form-group"><label>Sexo:</label><select name="sexo" required><option value="" disabled selected>Selecione</option><option value="Masculino">Masculino</option><option value="Feminino">Feminino</option></select></div>
        <div class="form-group"><label>Unidade:</label><input type="text" name="unidade" required></div>
        <div class="form-group"><label>Data de Aniversário:</label><input type="date" name="aniversario"></div>
        <div class="form-group"><label>CPF (será a senha inicial):</label><input type="text" name="cpf" required></div>
        <button type="submit" name="add_user" class="btn-add">Adicionar Usuário</button>
    </form>
    <?php endif; ?>

    <h2>Usuários Cadastrados</h2>
    <div class="search-container"><label for="searchInput">Buscar Usuário:</label><input type="text" id="searchInput" placeholder="Digite um nome ou CPF para filtrar..."></div>

    <table class="user-table">
        <thead><tr><th>Nome</th><th>Usuário</th><th>Cargo</th><th>Sexo</th><th>Unidade</th><th>Aniversário</th><th>CPF</th><th>Ações</th></tr></thead>
        <tbody id="userTableBody">
            <?php if (empty($usuarios)): ?>
                <tr><td colspan="8">Nenhum usuário cadastrado.</td></tr>
            <?php else: foreach ($usuarios as $usuario): ?>
            <tr>
                <td><?= htmlspecialchars($usuario['nome']) ?></td>
                <td><strong><?= htmlspecialchars($usuario['usuario']) ?></strong></td>
                <td><strong><?= htmlspecialchars($usuario['cargo'] ?? 'Colaborador') ?></strong></td>
                <td><?= htmlspecialchars($usuario['sexo'] ?? '-') ?></td>
                <td><?= htmlspecialchars($usuario['unidade']) ?></td>
                <td><?= !empty($usuario['aniversario']) ? htmlspecialchars(date('d/m', strtotime($usuario['aniversario']))) : '-' ?></td>
                <td><?= htmlspecialchars($usuario['cpf']) ?></td>
                <td>
                    <a href="?action=edit&cpf=<?= htmlspecialchars($usuario['cpf']) ?>" class="btn-edit">Editar</a>
                    <form method="post" onsubmit="return confirm('Tem certeza que deseja remover este usuário?');" style="display:inline; margin-left: 5px;">
                        <input type="hidden" name="cpf" value="<?= htmlspecialchars($usuario['cpf']) ?>">
                        <button type="submit" name="delete_user" class="btn-danger">Remover</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; endif; ?>
        </tbody>
    </table>
</div>

<style>
.user-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
.user-table th, .user-table td { border: 1px solid #ddd; padding: 10px; text-align: left; vertical-align: middle; }
.user-table th { background-color: #f2f2f2; }
.btn-danger, .btn-edit, .btn-cancel { padding: 8px 12px; border-radius: 5px; text-decoration: none; border: none; cursor: pointer; color: white; display: inline-block; }
.btn-danger { background-color: #d9534f; }
.btn-edit { background-color: #5bc0de; }
.btn-cancel { background-color: #777; }
.message { padding: 10px; margin-bottom: 15px; border-radius: 5px; text-align: center; font-weight: bold; }
.message.success { background-color: #dff0d8; color: #3c763d; }
.message.error { background-color: #f2dede; color: #a94442; }
.search-container { margin-bottom: 20px; }
.search-container label { font-weight: bold; display: block; margin-bottom: 5px; }
#searchInput { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
.form-group {padding: 0; background: none; border: none;}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const tableRows = document.querySelectorAll('#userTableBody tr');
    searchInput.addEventListener('keyup', function() {
        const searchTerm = searchInput.value.toLowerCase();
        tableRows.forEach(row => {
            const nameCell = row.cells[0].textContent.toLowerCase();
            const cpfCell = row.cells[6].textContent.toLowerCase(); 
            if (nameCell.includes(searchTerm) || cpfCell.includes(searchTerm)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });

    // VALIDAÇÃO EM TEMPO REAL DO CAMPO NOME
    const sanitizeInput = (inputElement) => {
        // Permite letras (incluindo acentuadas) e espaços. Remove todo o resto.
        const regex = /[^a-zA-Z\p{L}\s]/gu;
        inputElement.addEventListener('input', function() {
            this.value = this.value.replace(regex, '');
        });
    };

    // Aplica a validação ao campo de nome no formulário (seja de adição ou edição)
    const nomeInput = document.querySelector('form[action="gerenciar_usuarios.php"] input[name="nome"]');
    if (nomeInput) {
        sanitizeInput(nomeInput);
    }
});
</script>

<?php require_once 'admin_footer.php'; ?>