<?php
session_start();

define('PASSWORD_HASH', '$2y$10$4cdFO9uXSTkbapMsq5GV5ew017wPqoKf9VSO0wzPRlEcXooGEnbou'); 

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: painel.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (isset($_POST['password']) && password_verify($_POST['password'], PASSWORD_HASH)) {
        $_SESSION['loggedin'] = true;
        header('Location: painel.php');
        exit;
    } else {
        $error = 'Senha incorreta!';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login - Painel de Controle</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        body { display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f4f6f8; }
        .login-box { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 0 20px rgba(0,0,0,0.1); text-align: center; width: 350px; }
        .login-box h2 { margin-top: 0; color: #003366; }
        .login-box input { padding: 12px; width: 100%; margin-top: 10px; border-radius: 8px; border: 1px solid #ccc; box-sizing: border-box; }
        .login-box button { margin-top: 20px; width: 100%; cursor: pointer; border: none; background-color: var(--biavatti-dark-blue); color: white; padding: 12px; font-size: 1rem; border-radius: 8px;}
        .error { color: #d9534f; margin-top: 15px; font-weight: bold; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Acesso ao Painel</h2>
        <form method="post">
            <input type="password" name="password" placeholder="Digite a senha" required>
            <button type="submit">Entrar</button>
        </form>
        <?php if ($error): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
    </div>
</body>
</html>