<?php
// O header já inicia a sessão e faz a verificação de login
require_once 'admin_header.php';

// --- LÓGICA PARA COLETAR DADOS PARA O DASHBOARD ---

// 1. Caminhos dos arquivos (usando a estrutura segura)
// CORREÇÃO DE CAMINHO PARA AMBIENTE LOCAL (XAMPP)
$usuariosFile = 'usuarios.json';
$configFile = 'config.json';
// QUANDO FOR PARA PRODUÇÃO (HOSTINGER), USE A LINHA ABAIXO:
// $usuariosFile = __DIR__ . '/../../intranet_dados_seguros/usuarios.json';
// $configFile = __DIR__ . '/../../intranet_dados_seguros/config.json';

// ===== A LINHA QUE FALTAVA FOI ADICIONADA AQUI =====
// CORREÇÃO DE CAMINHO PARA AMBIENTE LOCAL (XAMPP)
$onlineDir = __DIR__ . '/../../intranet_activity_logs/online/';
// QUANDO FOR PARA PRODUÇÃO (HOSTINGER), o caminho já está correto.
// ===================================================

// 2. Carregar dados principais
$usuarios = file_exists($usuariosFile) ? json_decode(file_get_contents($usuariosFile), true) : [];
$configData = file_exists($configFile) ? json_decode(file_get_contents($configFile), true) : [];
if ($usuarios === null) $usuarios = [];
if ($configData === null) $configData = [];

// 3. Calcular Estatísticas
$totalUsuarios = count($usuarios);
$totalNoticias = count($configData['news'] ?? []);
$totalLinks = count($configData['quickAccessLinks'] ?? []);
$totalVideos = count($configData['videos'] ?? []);

// 4. Obter Atividade Recente
$ultimoUsuario = !empty($usuarios) ? end($usuarios)['nome'] : 'Nenhum usuário cadastrado';
$postMaisRecente = !empty($configData['news']) ? end($configData['news'])['title'] : 'Nenhuma notícia publicada';

// 5. Calcular Próximos Aniversários
$proximosAniversarios = [];
if (!empty($usuarios)) {
    $hoje = new DateTime(); $hoje->setTime(0, 0, 0);
    foreach ($usuarios as $usuario) {
        if (!empty($usuario['aniversario'])) {
            $niver = new DateTime($usuario['aniversario']);
            $niverEsteAno = new DateTime($hoje->format('Y') . '-' . $niver->format('m-d'));
            if ($niverEsteAno < $hoje) { $niverEsteAno->modify('+1 year'); }
            $diasParaAniversario = $hoje->diff($niverEsteAno)->days;
            $proximosAniversarios[] = ['nome' => $usuario['nome'], 'dias_faltando' => $diasParaAniversario, 'data_formatada' => $niver->format('d/m')];
        }
    }
    usort($proximosAniversarios, function($a, $b) { return $a['dias_faltando'] <=> $b['dias_faltando']; });
    $proximosAniversarios = array_slice($proximosAniversarios, 0, 3);
}

// 6. LÓGICA: USUÁRIOS ONLINE
$onlineUsers = [];
$timeout = 300; // 5 minutos em segundos
if (is_dir($onlineDir)) {
    $userMap = array_column($usuarios, 'nome', 'usuario');
    foreach (scandir($onlineDir) as $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) === 'user') {
            $filePath = $onlineDir . $file;
            $content = file_get_contents($filePath);
            if ($content) {
                list($username, $lastSeen) = explode('|', $content);
                if ((time() - $lastSeen) < $timeout) {
                    $onlineUsers[] = $userMap[$username] ?? $username;
                } else {
                    unlink($filePath);
                }
            }
        }
    }
}
$onlineUsers = array_unique($onlineUsers);
?>

<header>
    <h1>Dashboard</h1>
    <a href="logout.php" class="btn-logout">Sair</a>
</header>

<div class="dashboard-grid">
    <!-- Card de Atalhos Rápidos -->
    <div class="card dashboard-card quick-actions">
        <h2>Atalhos Rápidos</h2>
        <a href="gerenciar_conteudo.php" class="action-button"><i class="fas fa-edit"></i><span>Gerenciar Conteúdo</span></a>
        <a href="gerenciar_usuarios.php" class="action-button"><i class="fas fa-users"></i><span>Gerenciar Usuários</span></a>
        <a href="../index.php" target="_blank" class="action-button secondary"><i class="fas fa-eye"></i><span>Visualizar Intranet</span></a>
    </div>

    <!-- Cards de Estatísticas -->
    <div class="card dashboard-card stat-card"><div class="stat-icon users"><i class="fas fa-users"></i></div><div class="stat-info"><span class="stat-number"><?= $totalUsuarios ?></span><span class="stat-label">Usuários Cadastrados</span></div></div>
    <div class="card dashboard-card stat-card"><div class="stat-icon news"><i class="fas fa-newspaper"></i></div><div class="stat-info"><span class="stat-number"><?= $totalNoticias ?></span><span class="stat-label">Notícias Publicadas</span></div></div>
    <div class="card dashboard-card stat-card"><div class="stat-icon links"><i class="fas fa-link"></i></div><div class="stat-info"><span class="stat-number"><?= $totalLinks ?></span><span class="stat-label">Links Rápidos</span></div></div>
    <div class="card dashboard-card stat-card"><div class="stat-icon videos"><i class="fas fa-video"></i></div><div class="stat-info"><span class="stat-number"><?= $totalVideos ?></span><span class="stat-label">Vídeos Institucionais</span></div></div>

    <!-- Card de Usuários Online -->
    <div class="card dashboard-card online-users">
        <h2><i class="fas fa-wifi"></i> Usuários Online Agora (<?= count($onlineUsers) ?>)</h2>
        <?php if (!empty($onlineUsers)): ?>
            <ul>
                <?php foreach ($onlineUsers as $userName): ?>
                    <li><?= htmlspecialchars($userName) ?></li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p>Nenhum usuário ativo nos últimos 5 minutos.</p>
        <?php endif; ?>
    </div>

    <!-- Card de Atividade Recente -->
    <div class="card dashboard-card recent-activity">
        <h2>Atividade Recente</h2>
        <ul>
            <li><i class="fas fa-user-plus activity-icon"></i><div><span>Último Usuário Adicionado</span><strong><?= htmlspecialchars($ultimoUsuario) ?></strong></div></li>
            <li><i class="fas fa-file-alt activity-icon"></i><div><span>Notícia Mais Recente</span><strong><?= htmlspecialchars($postMaisRecente) ?></strong></div></li>
        </ul>
    </div>

    <!-- Card de Próximos Aniversários -->
    <div class="card dashboard-card upcoming-birthdays">
        <h2>Próximos Aniversários</h2>
        <?php if (!empty($proximosAniversarios)): ?>
            <ul>
                <?php foreach ($proximosAniversarios as $aniversariante): ?>
                    <li><i class="fas fa-birthday-cake birthday-icon"></i><div><strong><?= htmlspecialchars($aniversariante['nome']) ?></strong><span><?= htmlspecialchars($aniversariante['data_formatada']) ?> (em <?= $aniversariante['dias_faltando'] == 0 ? 'hoje!' : $aniversariante['dias_faltando'] . ' dias' ?>)</span></div></li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p>Nenhum aniversário próximo.</p>
        <?php endif; ?>
    </div>
</div>

<style>
/* Estilos específicos para o Dashboard */
.dashboard-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; }
.dashboard-card { display: flex; flex-direction: column; }
.dashboard-card h2 { font-size: 1.2rem; margin-top: 0; margin-bottom: 20px; color: var(--biavatti-dark-blue); border-bottom: 1px solid #eee; padding-bottom: 10px; }
.quick-actions .action-button { display: flex; align-items: center; background-color: var(--biavatti-accent-blue); color: white; padding: 15px; border-radius: 8px; text-decoration: none; margin-bottom: 10px; font-weight: 500; transition: all 0.3s ease; }
.quick-actions .action-button:hover { background-color: var(--biavatti-dark-blue); transform: translateY(-2px); box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
.quick-actions .action-button.secondary { background-color: #777; }
.quick-actions .action-button.secondary:hover { background-color: #555; }
.quick-actions .action-button i { font-size: 1.2rem; margin-right: 15px; width: 25px; text-align: center; }
.stat-card { flex-direction: row; align-items: center; }
.stat-icon { font-size: 2.5rem; padding: 20px; border-radius: 50%; margin-right: 20px; color: white; }
.stat-icon.users { background-color: #3498db; }
.stat-icon.news { background-color: #9b59b6; }
.stat-icon.links { background-color: #1abc9c; }
.stat-icon.videos { background-color: #e74c3c; }
.stat-info { display: flex; flex-direction: column; }
.stat-number { font-size: 2.2rem; font-weight: 600; color: var(--biavatti-dark-blue); }
.stat-label { font-size: 0.9rem; color: #777; }
.recent-activity ul, .upcoming-birthdays ul, .online-users ul { list-style: none; padding: 0; margin: 0; }
.recent-activity li, .upcoming-birthdays li, .online-users li { display: flex; align-items: center; padding: 10px 0; }
.recent-activity li:not(:last-child), .upcoming-birthdays li:not(:last-child), .online-users li:not(:last-child) { border-bottom: 1px solid #f0f0f0; }
.online-users li { padding: 8px 0; }
.recent-activity li div, .upcoming-birthdays li div { display: flex; flex-direction: column; }
.activity-icon, .birthday-icon { font-size: 1.5rem; margin-right: 15px; color: var(--biavatti-accent-blue); }
.birthday-icon { color: #f39c12; }
.recent-activity strong, .upcoming-birthdays strong { font-weight: 500; }
.recent-activity span, .upcoming-birthdays span { font-size: 0.9rem; color: #777; }
.online-users h2 i { color: #2ecc71; margin-right: 10px; }
</style>

<?php require_once 'admin_footer.php'; ?>