<?php
require_once 'admin_header.php';

$logFile = __DIR__ . '/../../intranet_activity_logs/access_log.csv';
$logEntries = [];
if (file_exists($logFile)) {
    $handle = fopen($logFile, 'r');
    while (($data = fgetcsv($handle)) !== FALSE) {
        $logEntries[] = $data;
    }
    fclose($handle);
    // Inverte o array para mostrar os logins mais recentes primeiro
    $logEntries = array_reverse($logEntries);
}
?>
<header>
    <h1>Log de Acesso dos Usuários</h1>
    <a href="logout.php" class="btn-logout">Sair</a>
</header>
<div class="card">
    <p>Esta página registra cada login bem-sucedido na intranet.</p>
    <table class="log-table">
        <thead>
            <tr>
                <th>Data</th>
                <th>Hora</th>
                <th>Usuário</th>
                <th>Nome Completo</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($logEntries)): ?>
                <tr><td colspan="4">Nenhum registro de acesso encontrado.</td></tr>
            <?php else: ?>
                <?php foreach ($logEntries as $entry): ?>
                <tr>
                    <td><?= htmlspecialchars($entry[0] ?? '') ?></td>
                    <td><?= htmlspecialchars($entry[1] ?? '') ?></td>
                    <td><?= htmlspecialchars($entry[2] ?? '') ?></td>
                    <td><?= htmlspecialchars($entry[3] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<style>
.log-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
.log-table th, .log-table td { border: 1px solid #ddd; padding: 10px; text-align: left; }
.log-table th { background-color: #f2f2f2; }
</style>
<?php require_once 'admin_footer.php'; ?>```